@extends('front.app_front')

@section('content')

<div class="search-section" style="background-image:url('{{ asset('uploads/site_photos/'.$page_home_items->search_background) }}');">
	<div class="bg"></div>
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<h1>{{ $page_home_items->search_heading }}</h1>
				<p>
					{{ $page_home_items->search_text }}
				</p>
				<div class="box">
					<form action="{{ url('search-hotel') }}" method="POST">
                        @csrf
						<div class="input-group input-box mb-3">
							<input type="text" class="form-control" placeholder="{{ FIND_ANYTHING }}" name="text">
							<select name="location[]" class="form-control select2">
								<option value="">{{ SELECT_LOCATION }}</option>
								@foreach($hotel_locations as $row)
									<option value="{{ $row->id }}">{{ $row->hotel_location_name }}</option>
								@endforeach
							</select>
							<select name="category[]" class="form-control select2">
								<option value="">{{ SELECT_CATEGORY }}</option>
								@foreach($hotel_categories as $row)
									<option value="{{ $row->id }}">{{ $row->hotel_category_name }}</option>
								@endforeach
							</select>
							<select name="hotel_type" class="form-control select2">
								<option value="">{{ SELECT_TYPE }}</option>
								<option value="star_no">{{ STAR_NO }}</option>
								<option value="star_1">{{ STAR_1 }}</option>
								<option value="star_2">{{ STAR_2 }}</option>
								<option value="star_3">{{ STAR_3 }}</option>
								<option value="star_4">{{ STAR_4 }}</option>
								<option value="star_5">{{ STAR_5 }}</option>
							</select>
							<div class="input-group-append">
								<button type="submit"><i class="fa fa-search"></i> {{ SEARCH }}</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>


@if($adv_home_data->above_category_status == 'Show')
<div class="ad-section">
	<div class="container">
		<div class="row">
			<div class="col-md-6 col-sm-12 wow fadeInUp">
				<div class="inner">
					@if($adv_home_data->above_category_1_url == '')
						<img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_category_1) }}" alt="">
					@else
						<a href="{{ $adv_home_data->above_category_1_url }}" target="_blank"><img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_category_1) }}" alt=""></a>
					@endif
				</div>
			</div>
			<div class="col-md-6 col-sm-12 wow fadeInUp">
				<div class="inner">
					@if($adv_home_data->above_category_2_url == '')
						<img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_category_2) }}" alt="">
					@else
						<a href="{{ $adv_home_data->above_category_2_url }}" target="_blank"><img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_category_2) }}" alt=""></a>
					@endif
				</div>
			</div>
		</div>
	</div>
</div>
@endif


@if($page_home_items->category_status == 'Show')
<div class="popular-category">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="heading">
					<h2>{{ $page_home_items->category_heading }}</h2>
					<h3>{{ $page_home_items->category_subheading }}</h3>
				</div>
			</div>
		</div>
		<div class="row">
            @php $i=0; @endphp
			@foreach($orderwise_hotel_categories as $row)
                @php $i++; @endphp
                @if($i>$page_home_items->category_total)
                    @break;
                @endif
				@if($row->total == '')
        		@php $row->total = 0; @endphp
        		@endif
				<div class="col-lg-3 col-md-6 col-sm-6 wow fadeInUp">
					<div class="popular-category-item effect-item" style="background-image: url({{ asset('uploads/hotel_category_photos/'.$row->hotel_category_photo) }});">
						<div class="bg image-effect"></div>
						<div class="text">
							<h4>{{ $row->hotel_category_name }}</h4>
                            @php
                                $qty = 0;
                                $categoryHotels = App\Models\Hotel::where('hotel_category_id', $row->id)->where('hotel_status','Active')->get();
                                foreach ($categoryHotels as $key => $categoryHotel) {
                                    if($categoryHotel->user_id != 0){
                                        $activePackage = App\Models\PackagePurchase::where('user_id',$categoryHotel->user_id)->where('currently_active',1)->first();
                                        if($activePackage->package_end_date >= date('Y-m-d')){
                                            $qty += 1;
                                        }
                                    }else{
                                        $qty += 1;
                                    }
                                }
                            @endphp
							<p>{{ $qty }} {{ ITEMS }}</p>
						</div>
						<a href="{{ route('front_hotel_category_detail',$row->hotel_category_slug) }}"></a>
					</div>
				</div>
			@endforeach
		</div>
	</div>
</div>
@endif


@if($adv_home_data->above_featured_hotel_status == 'Show')
<div class="ad-section">
	<div class="container">
		<div class="row">
			<div class="col-md-6 col-sm-12 wow fadeInUp">
				<div class="inner">
					@if($adv_home_data->above_featured_hotel_1_url == '')
						<img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_featured_hotel_1) }}" alt="">
					@else
						<a href="{{ $adv_home_data->above_featured_hotel_1_url }}" target="_blank"><img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_featured_hotel_1) }}" alt=""></a>
					@endif
				</div>
			</div>
			<div class="col-md-6 col-sm-12 wow fadeInUp">
				<div class="inner">
					@if($adv_home_data->above_featured_hotel_2_url == '')
						<img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_featured_hotel_2) }}" alt="">
					@else
						<a href="{{ $adv_home_data->above_featured_hotel_2_url }}" target="_blank"><img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_featured_hotel_2) }}" alt=""></a>
					@endif
				</div>
			</div>
		</div>
	</div>
</div>
@endif


@if($page_home_items->video_status == 'Show')
<div class="home-video" style="background-image: url({{ asset('uploads/site_photos/'.$page_home_items->video_background) }})">
    <div class="bg"></div>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h2>{{ $page_home_items->video_heading }}</h2>
                <p>
					{!! clean(nl2br($page_home_items->video_text)) !!}
                </p>
                <div class="video-section">
                    <a class="video-button" href="http://www.youtube.com/watch?v={{ $page_home_items->video_youtube_id }}"><i class="far fa-play-circle"></i></a>
                </div>
            </div>
        </div>
    </div>
</div>
@endif


@if($page_home_items->hotel_status == 'Show')
<div class="hotel">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="heading">
					<h2>{{ $page_home_items->hotel_heading }}</h2>
					<h3>{{ $page_home_items->hotel_subheading }}</h3>
				</div>
			</div>
		</div>
		<div class="row">
			@php
			$arr_max = array();
			for($j=0;$j<$page_home_items->hotel_total;$j++) {
				$arr_max[] = 3*$j+1;
			}
			@endphp
			@php $i=0; @endphp
			@foreach($hotels as $row)
			@php $i++; @endphp
			@if($i>$page_home_items->hotel_total)
				@break;
			@endif
			@if($i%3==0)
				@php $fade_val = 'fadeInRight' @endphp
			@elseif(in_array($i,$arr_max))
				@php $fade_val = 'fadeInLeft' @endphp
			@else
				@php $fade_val = 'fadeInUp' @endphp
			@endif
			<div class="col-lg-4 col-md-6 col-sm-12 wow {{ $fade_val }}">
				<div class="hotel-item effect-item">
					<div class="photo image-effect">
						<a href="{{ route('front_hotel_detail',$row->hotel_slug) }}"><img src="{{ asset('uploads/hotel_featured_photos/'.$row->hotel_featured_photo) }}" alt=""></a>
						<div class="category">
							<a href="{{ route('front_hotel_category_detail',$row->rHotelCategory->hotel_category_slug) }}">{{ $row->rHotelCategory->hotel_category_name }}</a>
						</div>
						<div class="wishlist">
							<a href="{{ route('front_add_wishlist',$row->id) }}"><i class="fas fa-heart"></i></a>
						</div>
						<div class="featured-text">{{ FEATURED }}</div>
					</div>
					<div class="text">

						<div class="type-price">
							<div class="type">
								<div class="inner-sale">
									{{ $row->hotel_type }}
								</div>
							</div>
							<div class="price">
								@if(!session()->get('currency_symbol'))
									${{ number_format($row->hotel_price) }}
								@else
									{{ session()->get('currency_symbol') }}{{ number_format($row->hotel_price*session()->get('currency_value')) }}
								@endif
								<span class="per-night">({{ PER_NIGHT }})</span>
							</div>
						</div>

						<h3><a href="{{ route('front_hotel_detail',$row->hotel_slug) }}">{{ $row->hotel_name }}</a></h3>
						<div class="location">
							<i class="fas fa-map-marker-alt"></i> {{ $row->rHotelLocation->hotel_location_name }}
						</div>

						@php
							$count=0;
							$total_number = 0;
							$overall_rating = 0;
							$reviews = \App\Models\Review::where('hotel_id',$row->id)->get();
						@endphp

						@if($reviews->isEmpty())

						@else

						@foreach($reviews as $item)
							@php
								$count++;
								$total_number = $total_number + $item->rating;
							@endphp
						@endforeach

						@php
							$overall_rating = $total_number/$count;
						@endphp

						@if($overall_rating>0 && $overall_rating<=1)
							@php $overall_rating = 1; @endphp

						@elseif($overall_rating>1 && $overall_rating<=1.5)
							@php $overall_rating = 1.5; @endphp

						@elseif($overall_rating>1.5 && $overall_rating<=2)
							@php $overall_rating = 2; @endphp

						@elseif($overall_rating>2 && $overall_rating<=2.5)
							@php $overall_rating = 2.5; @endphp

						@elseif($overall_rating>2.5 && $overall_rating<=3)
							@php $overall_rating = 3; @endphp

						@elseif($overall_rating>3 && $overall_rating<=3.5)
							@php $overall_rating = 3.5; @endphp

						@elseif($overall_rating>3.5 && $overall_rating<=4)
							@php $overall_rating = 4; @endphp

						@elseif($overall_rating>4 && $overall_rating<=4.5)
							@php $overall_rating = 4.5; @endphp

						@elseif($overall_rating>4.5 && $overall_rating<=5)
							@php $overall_rating = 5; @endphp

						@endif

						@endif

						<div class="review">
							@if($overall_rating == 5)
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
							@elseif($overall_rating == 4.5)
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star-half-alt"></i>
							@elseif($overall_rating == 4)
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="far fa-star"></i>
							@elseif($overall_rating == 3.5)
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star-half-alt"></i>
								<i class="far fa-star"></i>
							@elseif($overall_rating == 3)
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
							@elseif($overall_rating == 2.5)
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="fas fa-star-half-alt"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
							@elseif($overall_rating == 2)
								<i class="fas fa-star"></i>
								<i class="fas fa-star"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
							@elseif($overall_rating == 1.5)
								<i class="fas fa-star"></i>
								<i class="fas fa-star-half-alt"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
							@elseif($overall_rating == 1)
								<i class="fas fa-star"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
							@elseif($overall_rating == 0)
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
								<i class="far fa-star"></i>
							@endif
							<span>({{ $count }} {{ REVIEWS }})</span>
						</div>

					</div>
				</div>
			</div>
			@endforeach				
		</div>
	</div>
</div>
@endif


@if($page_home_items->testimonial_status == 'Show')
<div class="testimonial" style="background-image:url('{{ asset('uploads/site_photos/'.$page_home_items->testimonial_background) }}');">
    <div class="testimonial-bg"></div>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="heading">
                    <h2>{{ $page_home_items->testimonial_heading }}</h2>
					<h3>{{ $page_home_items->testimonial_subheading }}</h3>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="testimonial-carousel owl-carousel">
					@foreach($testimonials as $row)
					<div class="testimonial-item wow fadeInUp">
                        <div class="photo">
                            <img src="{{ asset('uploads/testimonials/'.$row->photo) }}" alt="">
                        </div>
                        <div class="text">
                            <p>
                                {!! clean(nl2br($row->comment)) !!}
                            </p>
                            <h3>{{ $row->name }}</h3>
                            <h4>{{ $row->designation }}</h4>
                        </div>
                    </div>
					@endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endif



@if($adv_home_data->above_location_status == 'Show')
<div class="ad-section">
	<div class="container">
		<div class="row">
			<div class="col-md-6 col-sm-12 wow fadeInUp">
				<div class="inner">
					@if($adv_home_data->above_location_1_url == '')
						<img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_location_1) }}" alt="">
					@else
						<a href="{{ $adv_home_data->above_location_1_url }}" target="_blank"><img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_location_1) }}" alt=""></a>
					@endif
				</div>
			</div>
			<div class="col-md-6 col-sm-12 wow fadeInUp">
				<div class="inner">
					@if($adv_home_data->above_location_2_url == '')
						<img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_location_2) }}" alt="">
					@else
						<a href="{{ $adv_home_data->above_location_2_url }}" target="_blank"><img src="{{ asset('uploads/advertisements/'.$adv_home_data->above_location_2) }}" alt=""></a>
					@endif
				</div>
			</div>
		</div>
	</div>
</div>
@endif


@if($page_home_items->location_status == 'Show')
<div class="popular-city">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="heading">
					<h2>{{ $page_home_items->location_heading }}</h2>
					<h3>{{ $page_home_items->location_subheading }}</h3>
				</div>
			</div>
		</div>
		<div class="row">
			
			@php $i=0; @endphp
			@foreach($orderwise_hotel_locations as $row)
				@php $i++; @endphp
				@if($i>$page_home_items->location_total)
					@break;
				@endif
				@if($row->total == '')
					@php $row->total = 0; @endphp
				@endif
				<div class="col-lg-3 col-md-6 col-sm-6 wow fadeInUp">
					<div class="popular-city-item effect-item">
						<div class="photo image-effect">
							<img src="{{ asset('uploads/hotel_location_photos/'.$row->hotel_location_photo) }}" alt="">
						</div>				
						<div class="text">
							<h4>{{ $row->hotel_location_name }}</h4>
							@php
								$qty = 0;
								$locationHotels = App\Models\Hotel::where('hotel_location_id', $row->id)->where('hotel_status','Active')->get();
								foreach ($locationHotels as $key => $categoryHotel) {
									if($categoryHotel->user_id != 0){
										$activePackage = App\Models\PackagePurchase::where('user_id',$categoryHotel->user_id)->where('currently_active',1)->first();
										if($activePackage->package_end_date >= date('Y-m-d')){
											$qty += 1;
										}
									}else{
										$qty += 1;
									}
								}
							@endphp
							<p>{{ $qty }} {{ HOTELS }}</p>
						</div>
						<a href="{{ route('front_hotel_location_detail',$row->hotel_location_slug) }}"></a>
					</div>
				</div>
			@endforeach
				

		</div>
	</div>
</div>
@endif

@endsection
